#include <bits/stdc++.h>
using namespace std;
bool is_prefix(long long a, long long b) {
    string sa = to_string(a);
    string sb = to_string(b);
    if (sb.size() > sa.size()) return false;
    return sa.substr(0, sb.size()) == sb;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<long long> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i];

    sort(a.begin(), a.end(), [](long long x, long long y) {
        string sx = to_string(x);
        string sy = to_string(y);
        if (sx.size() != sy.size()) return sx.size() < sy.size();
        return sx < sy;
    });

    vector<vector<long long>> ans;

    for (long long x : a) {
        bool added = false;
        for (auto &subset : ans) {
            for (long long y : subset) {
                if (is_prefix(x, y) || is_prefix(y, x)) {
                    subset.push_back(x);
                    added = true;
                    break;
                }
            }
            if (added) break;
        }
        if (!added) {
            ans.push_back({x});
        }
    }

    cout << ans.size() << "\n";
    for (auto &subset : ans) {
        cout << subset.size() << "\n";
        for (long long x : subset) cout << x << " ";
        cout << "\n";
    }
    return 0;
}